
"SpatiaLite laden:"
PRAGMA trusted_schema=1;
--Beispiel Linux
select load_extension('C:\Program Files\QGIS 3.40.4\bin\mod_spatialite.dll');PRAGMA trusted_schema=1;
--Beispiel Windows
select load_extension('/usr/lib/x86_64-linux-gnu/mod_spatialite.so');PRAGMA trusted_schema=1;
--Beispiel Mac
select load_extension('/Applications/QGIS-LTR.app/Contents/MacOS/lib/mod_spatialite.dylib');PRAGMA trusted_schema=1;

/* Geopackage Systemtabellen und Geometrieanmeldung */
select gpkgCreateBaseTables(); --Geopackage-basistabellen

select gpkgAddGeometryColumn('tablename','geometry_column','geometrytype',0,0,25832); --(oo für die Nicht-verwendung von z und m
select gpkgAddGeometryTriggers('tablename','geometry_column_name');
select gpkgAddSpatialIndex('tablename','geometry_column_name');
select gpkgInsertEpsgSRID( 25832);


"#######################################"
'Neue räumliche Tabelle mit SQL anlegen'
"########################################"
/* Anlegen eines Punktlayers über SQL */
1. Tabelle ohne Geometry-Spalte anlegen
	select DropTable('hydranten','');
	create table hydranten(
	fid   INTEGER     PRIMARY KEY Autoincrement,
	hyd_name text,
	xc integer,
	yc integer
	);

2. Geometrie-Spalte anlegen, Geometrie-Trigger und räumlichen Index anlegen
	select gpkgAddGeometryColumn('hydranten','geom','POINT',0,0,25832);
	select gpkgAddGeometryTriggers('hydranten','geom');
	select gpkgAddSpatialIndex('hydranten','geom');
	
	select gpkgInsertEpsgSRID(25832);

3.	
	"Geopackage-Modus einschlaten
	SELECT EnableGpkgMode();

"#######################################"
'Neue räumliche Tabelle mit SQL angelegt '
"########################################"

"###################################"
'Neue nicht räumliche Tabelle mit SQL anlegen'
"#####################################
create table test(
fid integer PRIMARY KEY AUTOINCREMENT,
material text,
jahreskosten_qm double
);
insert into gpkg_contents (table_name, data_type, identifier, srs_id)
values ('test', 'attributes', 'test', 0)
;
"########################
"Views und SpatialViews im Geopackage löschen*/	
"############################################
drop view test;

-- Einträge in metaTabellen löschen
delete from gpkg_ogr_contents
where table_name = 'test'
;

delete from gpkg_contents
where table_name = 'test'
;

delete from gpkg_geometry_columns
where table_name = 'test'
;

"########################
"SpatialView im Geopackage 
"########################
create view test as
SELECT
row_number() over() as fid,
lage,
setSrid(st_Multi(st_union(castautomagic(geom))),25832) as geom
from test
where lage is not NULL
group by lage
;

insert into gpkg_contents (table_name, data_type, identifier, srs_id)
values ('test', 'features', 'test', 25832)
;

insert into gpkg_geometry_columns (table_name, column_name, geometry_type_name, srs_id, z, m)
values ('test','geom','MULTIPOINT',25832,0,0)
;
insert into gpkg_ogr_contents
(table_name, feature_count)
values('test', (select count(fid) from test))
;
select gpkgAddSpatialIndex('test','geom');

with koord as
	(
	select 
	cast(MBrMinx(geom) as integer) as min_x,
	cast(MBrMaxx(geom) as integer) as min_y,
	cast(MBrMiny(geom) as integer) as max_x,
	cast(MBrMaxy(geom) as integer) as max_y
	from test
	)
update gpkg_contents
SET
min_x = a.min_x ,
min_y = a.min_y,
max_x = a.max_x,
max_y = a.max_y
from koord as a
where table_name = 'test'
;



/* Einfacher geht mit */

select gpkgCreateBaseTables(); --Geopackage-basistabellen

select gpkgAddGeometryColumn('tablename','geometry_column','geometrytype',0,0,25832); --(oo für die Nicht-verwendung von z und m
select gpkgAddGeometryTriggers('tablename','geometry_column_name');
select gpkgAddSpatialIndex('tablename','geometry_column_name');
select gpkgInsertEpsgSRID( 25832);
------------------
"#################################################
"# Anmedlung der Geometrien in Spatialite 
"#############################################

select recovergeometrycolumn('layername','geom',25832,'MULTIPOLYGON');
select createspatialindex('layername','geom');
select updatelayerstatistics('layername');


Spatialview:
Geometrytabelle mit ROWID abfragen

insert into views_geometry_columns
(view_name,view_geometry,view_rowid,f_table_name,f_geometry_column,read_only)
Values ('testview', 'geom', 'rowid','quelllayer','geom','1')


