import sqlite3 as sq
from sys import platform


skript = __file__

#proj_verz =  os.path.normpath(QgsProject.instance().homePath())
#print(proj_verz)

# Datei name und Verzeichnis in getrennte Variablen schreiben
inverz, indat = os.path.split(skript)

db_path  = os.path.normpath(inverz +  "/ZaubernGeopackage_2025.gpkg")
print(db_path) 

#Datenbank verbinden
db = sq.connect(db_path) 
# Laden von Erweiterungen erlauben
db.enable_load_extension(True)

# Spatialite laden
if platform == "linux":
    db.load_extension("/usr/lib/x86_64-linux-gnu/mod_spatialite.so")
elif platform == "darwin":
    db.load_extension('/Applications/QGIS-LTR.app/Contents/MacOS/lib/mod_spatialite.dylib')
elif platform == "win32":
    db.load_extension(os.path.normpath('C:\Program Files\QGIS 3.40.10\bin\mod_spatialite.dll'))

# Cursor anlegen: Über den Cursor kann in die datenbank geschrieben werden    
dbc = db.cursor()

# SQL-Abfrage als Text in variable abf schreiben
abf = """
        select 
        nam_de,
        round(sum(st_length(castautomagic(geom)))) as strecke
        from wege_netz as a join material as b on (a.surface = b.nam_eng)
        group by b.nam_de;
   """
# Abfrage ausführen
dbc.execute(abf)

# Ergebnis als Python-Objekt (Tupel) holen
ergebnis = dbc.fetchall() 

dbc.close()         # cursor schließen
db.close()         # Datenbank schließeen

for el in ergebnis:
    if len(str(el[0])) < 6:
        abst = chr(9) + chr(9) + chr(9) 
    elif len(str(el[0])) >= 6: #and len(str(el[0])) < 16:
        abst = chr(9) + chr(9) 
    else:
        abst = chr(9)
        
    eintrag = str(el[0]) + ': ' + abst + str(el[1]) + ' m'
    print(eintrag) 

# In CSV Datei schreiben
kopf = ['name',';','strecke','\n']
ausgabe = os.path.normpath(inverz + '/ausgabe.csv')
aus_datei = open(ausgabe,'w') 

writelist  = kopf

for el in ergebnis:
    erg = el[0] + ";" + str(round(el[1])).replace('.',',')
    erg = erg + ("\n")
    writelist.append(erg)   

#print(writelist)
aus_datei.writelines(writelist)
aus_datei.close() 
    

